<?php
/* --------------------------------------------------------------
   LanguageSortings.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Language\SqlCriteria;

use ArrayIterator;
use Gambio\Core\Criteria\SqlSortings;
use Traversable;

/**
 * Class LanguageSortings
 *
 * @package Gambio\Core\Language\SqlCriteria
 */
class LanguageSortings implements SqlSortings
{
    /**
     * @var LanguageSorting[]
     */
    private $sortings;
    
    
    /**
     * LanguageSortings constructor.
     *
     * @param LanguageSorting ...$sortings
     */
    private function __construct(LanguageSorting ...$sortings)
    {
        $this->sortings = $sortings;
    }
    
    
    /**
     * @param LanguageSorting ...$sortings
     *
     * @return LanguageSortings
     */
    public static function create(LanguageSorting ...$sortings): LanguageSortings
    {
        return new self(...$sortings);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getIterator(): Traversable
    {
        return new ArrayIterator($this->sortings);
    }
}